<?php
require_once '../Admin/config.php';
// Include the database connection details

$conn = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);


function generateRandomTransactionID($conn) {
    $prefix = "EF-";
    $unique = false;

    while (!$unique) {
        $randomNumber = rand(1000000000, 9999999999); // Generate a random 10-digit number
        $transactionID = $prefix . $randomNumber;

        // Check if the generated transaction ID already exists in the database
        $stmt = $conn->prepare("SELECT COUNT(*) AS count FROM transactions WHERE transaction_id = ?");
        $stmt->bind_param("s", $transactionID);
        $stmt->execute();
        $result = $stmt->get_result();

        $row = $result->fetch_assoc();
        if ($row['count'] == 0) {
            $unique = true;
        }
    }

    return $transactionID;
}

function addTransaction($senderName,$senderCountry,$receiverCountry, $senderNumber, $amount, $operator, $fee, $receiverName, $receiverNumber, $status, $transactionTime, $notes, $transactionID,$feeStatus) {
    global $conn;

    // Sanitize and validate input (Please enhance the validation as per your requirements)
    $feeStatus = mysqli_real_escape_string($conn, $feeStatus);
    $senderCountry = mysqli_real_escape_string($conn, $senderCountry);
    $receiverCountry = mysqli_real_escape_string($conn, $receiverCountry);
    $senderName = mysqli_real_escape_string($conn, $senderName);
    $senderNumber = mysqli_real_escape_string($conn, $senderNumber);
    $amount = mysqli_real_escape_string($conn, $amount);
    $operator = mysqli_real_escape_string($conn, $operator);
    $transactionID = mysqli_real_escape_string($conn, $transactionID);
    $fee = mysqli_real_escape_string($conn, $fee);
    $receiverName = mysqli_real_escape_string($conn, $receiverName);
    $receiverNumber = mysqli_real_escape_string($conn, $receiverNumber);
    $status = mysqli_real_escape_string($conn, $status);
    $transactionTime = mysqli_real_escape_string($conn, $transactionTime);
    $notes = mysqli_real_escape_string($conn, $notes);
    $user_id = $_SESSION['username']; // Assuming you have the user's ID in the session

    if ($operator == "EF Cash") {
        $transactionID = generateRandomTransactionID($conn);
    } else {
        $transactionID = $_POST["transactionID"];
    }

    $served_by = null;
    $completed_by = null;

    if ($status == "Served") {
        $served_by = $user_id;
        $completed_by = $user_id;
    } elseif ($status == "Not Served") {
        $served_by = $user_id;
    }

    $stmt = $conn->prepare("INSERT INTO transactions (sender_name,sender_country,reciever_country, sender_number, amount, operator, transaction_id, fee, reciever_name, reciever_number, status, transaction_time, notes, served_by, completed_by,fee_status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
    $stmt->bind_param("ssssssssssssssss", $senderName,$senderCountry,$receiverCountry, $senderNumber, $amount, $operator, $transactionID, $fee, $receiverName, $receiverNumber, $status, $transactionTime, $notes, $served_by, $completed_by,$feeStatus);

    $result = $stmt->execute();

    if ($result) {
        echo '<script>Toastify({
            text: "Transaction Added successfully",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #4CAF50, #8BC34A)"
        }).showToast();</script>';
    } else {
        echo '<script>Toastify({
            text: "Oops, Something went wrong",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)"
        }).showToast();</script>';
    }
}


function getAllTransactions() {
    global $conn; // Access the global connection
    $username = $_SESSION['username']; // Assuming you have the user's username in the session
    $transactions = array();

    $query = "SELECT * FROM transactions WHERE (served_by = ? OR completed_by = ?) ORDER BY time DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ss", $username, $username);
    $stmt->execute();
    
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $transactions[] = $row;
        }
    }

    return $transactions;
}

function getTransactionById($transactionId) {
    global $conn;

    $transaction = null;

    $stmt = $conn->prepare("SELECT * FROM transactions WHERE id = ?");
    $stmt->bind_param("s", $transactionId);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result && $result->num_rows === 1) {
        $transaction = $result->fetch_assoc();
    }

    return $transaction;
}

function getTransactionByIdPuller($transactionId) {
    global $conn;

    $transaction = null;

    $stmt = $conn->prepare("SELECT * FROM transactions WHERE transaction_id = ?");
    $stmt->bind_param("s", $transactionId);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result && $result->num_rows === 1) {
        $transaction = $result->fetch_assoc();
    }

    return $transaction;
}

function updateTransaction($id, $senderName, $senderCountry,$receiverCountry,$senderNumber, $amount, $fee, $receiverName, $receiverNumber, $status, $transactionTime, $notes,$transactionID,$fee_status) {
    global $conn;
    $username = $_SESSION['username']; // Assuming you have the user's ID in the session

$stmt = $conn->prepare("UPDATE transactions SET sender_name=?, sender_number=?, amount=?, fee=?, reciever_name=?, reciever_number=?, status=?, transaction_time=?, notes=? ,transaction_id=?,completed_by=?,fee_status=? WHERE id=?");
$stmt->bind_param("sssssdsdssssi", $senderName, $senderNumber, $amount, $fee, $receiverName, $receiverNumber, $status, $transactionTime, $notes, $transactionID, $username, $fee_status, $id);


    $result = $stmt->execute();$stmt = $conn->prepare("UPDATE transactions SET sender_name=?, sender_number=?, amount=?, fee=?, reciever_name=?, reciever_number=?, status=?, transaction_time=?, notes=? ,transaction_id=?,completed_by=?,fee_status=? WHERE id=?");
$stmt->bind_param("sssssdsdssssi", $senderName, $senderNumber, $amount, $fee, $receiverName, $receiverNumber, $status, $transactionTime, $notes, $transactionID, $username, $fee_status, $id);


    if ($result) {
        echo '<script>Toastify({
            text: "Transaction Updated successfully",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #4CAF50, #8BC34A)"
        }).showToast();</script>';
    } else {
        echo '<script>Toastify({
            text: "Oops, Error Updating Transaction",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)"
        }).showToast();</script>';
    }
}
//add agents / users
function addUser($username, $email, $fullName, $country, $location, $contact, $password, $role) {
    global $conn;

    // Validate and sanitize input
    $username = mysqli_real_escape_string($conn, $username);
    $email = mysqli_real_escape_string($conn, $email);
    $fullName = mysqli_real_escape_string($conn, $fullName);
    $country = mysqli_real_escape_string($conn, $country);
    $location = mysqli_real_escape_string($conn, $location);
    $contact = mysqli_real_escape_string($conn,$contact);
    $password = mysqli_real_escape_string($conn, $password);
    $role = mysqli_real_escape_string($conn, $role);

    // Check for duplicate username or email
    $stmt = $conn->prepare("SELECT user_id FROM users WHERE username = ? OR email = ?");
    $stmt->bind_param("ss", $username, $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $_SESSION['submitted_values'] = $_POST;
        echo '<script>Toastify({
            text: "Username or Email already exists.",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)"
        }).showToast();</script>';
        return;
    }

    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Prepare and execute the SQL query
    $stmt = $conn->prepare("INSERT INTO users (username, email, full_name, country, `location`, contact, `password`, role) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssss", $username, $email, $fullName, $country, $location, $contact, $hashedPassword, $role);

    if ($stmt->execute()) {
        unset($_SESSION['submitted_values']);
        echo '<script>Toastify({
            text: "Agent Added successfully",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #4CAF50, #8BC34A)"
        }).showToast();</script>';
    } else {
        $_SESSION['submitted_values'] = $_POST;
        echo '<script>Toastify({
            text: "Oops, Something went wrong...",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)"
        }).showToast();</script>';
    }
}

function getAllAgents() {
    global $conn; // Access the global connection

    $agents = array();

    $query = "SELECT * FROM users ORDER BY time DESC";
    $result = $conn->query($query);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $agents[] = $row;
        }
    }

    return $agents;
}

function getAgentById($agentID){
    global $conn;

    $agent = null;

    $stmt = $conn->prepare("SELECT * FROM users WHERE user_id = ?");
    $stmt->bind_param("d", $agentID);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result && $result->num_rows === 1) {
        $agent = $result->fetch_assoc();
    }

    return $agent;
}

function updateUser($id, $username, $email, $agentName, $country, $location, $agentContact, $password, $role) {
    global $conn;

    // Validate and sanitize input
    $id = intval($id);
    $username = mysqli_real_escape_string($conn, $username);
    $email = mysqli_real_escape_string($conn, $email);
    $agentName = mysqli_real_escape_string($conn, $agentName);
    $country = mysqli_real_escape_string($conn, $country);
    $location = mysqli_real_escape_string($conn, $location);
    $agentContact = mysqli_real_escape_string($conn,$agentContact);
    $role = mysqli_real_escape_string($conn, $role);

    // Hash the password if it's not empty
    if (!empty($password)) {
        $password = mysqli_real_escape_string($conn, $password);
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
        $passwordClause = ", password = '$hashedPassword'";
    } else {
        $passwordClause = "";
    }

    // Check for duplicate username and email among other users
    $stmt = $conn->prepare("SELECT * FROM users WHERE (username = ? OR email = ?) AND user_id != ?");
    $stmt->bind_param("ssi", $username, $email, $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // Duplicate username or email
        echo '<script>Toastify({
            text: "Username or Email already exists",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)"
        }).showToast();</script>';
        return;
    }

    // Prepare and execute the SQL query
    $sql = "UPDATE users SET username = ?, email = ?, full_name = ?, country = ?, `location` = ?, contact = ?, role = ? $passwordClause WHERE user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssi", $username, $email, $agentName, $country, $location, $agentContact, $role, $id);

    if ($stmt->execute()) {
        echo '<script>Toastify({
            text: "User Updated successfully",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #4CAF50, #8BC34A)"
        }).showToast();</script>';
    } else {
        echo '<script>Toastify({
            text: "Oops, Something went wrong...",
            duration: 6000,
            backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)"
        }).showToast();</script>';
    }
}

function getTotalTransactionsForUser($username) {
    global $conn;

    $query = "SELECT COUNT(*) FROM transactions WHERE served_by = ? OR completed_by = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ss", $username, $username);
    $stmt->execute();
    $stmt->bind_result($totalTransactions);
    $stmt->fetch();
    $stmt->close();

    return $totalTransactions;
}

function getTotalAmountForUser($username) {
    global $conn;

    $query = "SELECT SUM(amount) FROM transactions WHERE served_by = ? OR completed_by = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ss", $username, $username);
    $stmt->execute();
    $stmt->bind_result($totalAmount);
    $stmt->fetch();
    $stmt->close();

    return $totalAmount;
}

function getTotalTransactionsForUserToday($username) {
    global $conn;

    $today = date("Y-m-d");

    $query = "SELECT COUNT(*) FROM transactions WHERE (served_by = ? OR completed_by = ?) AND DATE(time) = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sss", $username, $username, $today);
    $stmt->execute();
    $stmt->bind_result($totalTransactionsToday);
    $stmt->fetch();
    $stmt->close();

    return $totalTransactionsToday;
}

function getTotalAmountForUserToday($username) {
    global $conn;

    $today = date("Y-m-d");

    $query = "SELECT SUM(amount) FROM transactions WHERE (served_by = ? OR completed_by = ?) AND DATE(time) = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sss", $username, $username, $today);
    $stmt->execute();
    $stmt->bind_result($totalAmountToday);
    $stmt->fetch();
    $stmt->close();

    return $totalAmountToday;
}

function getTopTransactions($username) {
    global $conn; // Access the global connection

    $transactions = array();

    $query = "SELECT * FROM transactions WHERE served_by = ? OR completed_by = ? ORDER BY amount DESC LIMIT 10";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ss", $username, $username);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $transactions[] = $row;
        }
    }

    return $transactions;
}



