<?php require_once('Auth/authorize.php');?>
<?php include_once('partials/header.php');?>
<?php include_once('partials/admin_functions.php');?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_settings-panel.html -->
      <div class="theme-setting-wrapper">
        <div id="settings-trigger"><i class="ti-settings"></i></div>
        <div id="theme-settings" class="settings-panel">
          <i class="settings-close ti-close"></i>
          <p class="settings-heading">SIDEBAR SKINS</p>
          <div class="sidebar-bg-options selected" id="sidebar-light-theme"><div class="img-ss rounded-circle bg-light border mr-3"></div>Light</div>
          <div class="sidebar-bg-options" id="sidebar-dark-theme"><div class="img-ss rounded-circle bg-dark border mr-3"></div>Dark</div>
          <p class="settings-heading mt-2">HEADER SKINS</p>
          <div class="color-tiles mx-0 px-4">
            <div class="tiles success"></div>
            <div class="tiles warning"></div>
            <div class="tiles danger"></div>
            <div class="tiles info"></div>
            <div class="tiles dark"></div>
            <div class="tiles default"></div>
          </div>
        </div>
      </div>
      <!-- partial -->
      <!-- partial:partials/_sidebar.html -->
     <?php include_once('partials/nav.php');?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-md-12 grid-margin">
              <div class="row">
                <div class="col-12 col-xl-8 mb-4 mb-xl-0">
                  <h3 class="font-weight-bold">Welcome <?php echo $_SESSION['username'];?></h3>
                  <h6 class="font-weight-normal mb-0">All systems are running smoothly!</h6>
                </div>
       
              </div>
            </div>
          </div>
         <?php include_once('partials/numbers.php');?>
          
          <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <p class="card-title mb-0">Top 10 Transactions</p>
                  <div class="table-responsive">
                  <table class="table table-striped table-borderless">
                      <thead>
                        <tr>
                          <th>Operator</th>
                          <th>Amount</th>
                          <th>Completed (Date)</th>
                          <th>Status</th>
                          <th>TrasID</th>
                          <th>Initiated by</th>
                        </tr>  
                      </thead>
                      <tbody>
                        <?php foreach ($topTransactions as $key => $transaction):?>
                        <tr>
                          <td><?php echo $transaction['operator'];?></td>
                          <td class="font-weight-bold">$<?php echo number_format($transaction['amount'], 2, '.', ',')?></td>
                          <td><?php echo date('F j, Y - g:i A', strtotime($transaction['completed_at'])); ?></td>
                          <td class="font-weight-medium"><div class="badge <?php if($transaction['status'] == "Served"){echo "badge-success";}else{echo "badge-warning";}?>"><?php echo $transaction['status'];?></div></td>
                          <td><?php echo $transaction['transaction_id'];?></td>
                          <td><?php echo $transaction['served_by'];?></td>
                        </tr>
                       
                        <?php endforeach?>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
       
          </div>
        </div>

        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
       <?php include_once('partials/footer.php');?>