<?php require_once('Auth/authorize.php');?>
<?php
// Check if a delete notification exists
if (isset($_SESSION["delete_notification"])) {
    $deleteNotification = $_SESSION["delete_notification"];
    unset($_SESSION["delete_notification"]);
}
?>
<?php include_once('partials/header.php');?>
<?php include_once('partials/agent_functions.php');?>

<?php
$allTransactions = getAllTransactions();
?>

    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_settings-panel.html -->
      <div class="theme-setting-wrapper">
        <div id="settings-trigger"><i class="ti-settings"></i></div>
        <div id="theme-settings" class="settings-panel">
          <i class="settings-close ti-close"></i>
          <p class="settings-heading">SIDEBAR SKINS</p>
          <div class="sidebar-bg-options selected" id="sidebar-light-theme"><div class="img-ss rounded-circle bg-light border mr-3"></div>Light</div>
          <div class="sidebar-bg-options" id="sidebar-dark-theme"><div class="img-ss rounded-circle bg-dark border mr-3"></div>Dark</div>
          <p class="settings-heading mt-2">HEADER SKINS</p>
          <div class="color-tiles mx-0 px-4">
            <div class="tiles success"></div>
            <div class="tiles warning"></div>
            <div class="tiles danger"></div>
            <div class="tiles info"></div>
            <div class="tiles dark"></div>
            <div class="tiles default"></div>
          </div>
        </div>
      </div>
      <!-- partial -->
      <!-- partial:partials/_sidebar.html -->
     <?php include_once('partials/nav.php');?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-md-12 grid-margin">
            <div class="col-lg-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">All Transactions</h4>
                  <p class="card-description">
                  <a href="Add_transaction" class="btn btn-dark mr-2">Add Transaction</a>
                  </p>
                  <div class="table-responsive">
                    <table class="table table-hover">
                      <thead>
                        <tr>
                          <th>#</th>
                          <th>#TransID</th>
                          <th>Sender's Name</th>
                          <th>Served By</th>
                          <th>Completed By</th>
                          <th>Fee</th>
                          <th>Amount</th>
                          <th>Operator</th>
                          <th>Status</th>
                          <th>Date</th>
                          <th>Actions</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($allTransactions as $key => $transaction):?>
                        <tr>
                          <td><?php echo $key+1;?></td>
                          <td><?php echo $transaction['transaction_id'];?></td>
                          <td><?php echo $transaction['sender_name'];?></td>
                          <td><?php echo $transaction['served_by'];?></td>
                          <td><?php echo $transaction['completed_by'];?></td>
                          <td class="text-danger"><?php echo $transaction['fee'];?>%<i class="<?php if($transaction['status'] == "Not Served"){echo "ti-arrow-down";}else{echo "ti-arrow-up";}?>"></i></td>
                          <td><?php echo $transaction['amount'];?></td>
                          <td><?php echo $transaction['operator'];?></td>

                          <td><label class="badge <?php if($transaction['status'] == "Not Served"){echo "badge-warning";}elseif($transaction['status'] == "Served"){echo "badge-success";}else{echo "badge-danger";}?>"><?php echo $transaction['status'];?></label></td>
                          <td><?php echo $transaction['transaction_time'];?></td>
                          <td>
                          <div class="dropdown">
                          <button class="btn btn-dark dropdown-toggle btn-sm" type="button" id="dropdownMenuIconButton1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                      
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton1">
                            <h6 class="dropdown-header">Options</h6>
                           
                            <a href="Update_Transaction?TRID=<?php echo $transaction['id']?>" class="dropdown-item edit-mp-btn" id="edit-mp">Edit</a>
     
                            <div class="dropdown-divider"></div>
                            <button class="dropdown-item print-button" data-transaction-id="<?php echo $transaction['id'];?>">Print</button>

                          </div>
                        </div>
                          </td>
                        </tr>
                      
                        <?php endforeach?>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
            <script>
    $(document).ready(function() {
        $(".table").DataTable({
    pagingType: "full_numbers",
    lengthMenu: [10, 15, 25, 50, 100],
    pageLength: 10,
  });
    });

    document.addEventListener("DOMContentLoaded", function () {
  // Get all the "Print" buttons with the class "print-button"
  const printButtons = document.querySelectorAll(".print-button");

  // Add click event listener to each "Print" button
  printButtons.forEach(function (button) {
    button.addEventListener("click", function () {
      const transactionId = button.dataset.transactionId;
      window.location.href = `Print?TRID=${transactionId}`;
    });
  });
});

</script>
               <!-- Display notification if it exists -->
               <?php if (isset($deleteNotification)): ?>
<script>
    var deleteNotification = "<?php echo $deleteNotification; ?>";
    Toastify({
        text: deleteNotification,
        duration: 6000,
        backgroundColor: "linear-gradient(to right, #4CAF50, #8BC34A)"
    }).showToast();
</script>
<?php endif; ?>

        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
       <?php include_once('partials/footer.php');?>