function toggleTransactionIDInput() {
  var operatorSelect = document.getElementById("operator");
  var transactionIDInput = document.getElementById("transactionIDContainer");

  if (operatorSelect.value === "EF Cash") {
    Toastify({
      text: "Transaction ID will generate Automatically",
      duration: 6000,
      backgroundColor: "linear-gradient(to right, #4CBF50, #3BC34A)",
    }).showToast();
    transactionIDInput.style.display = "none";
  } else {
    transactionIDInput.style.display = "block";
  }
}

//delete transaction
function deleteTransaction(buttonElement) {
  const transactionId = buttonElement.getAttribute("data-transaction-id");
  const confirmed = confirm(
    "Are you sure you want to delete this transaction? This action cannot be undone."
  );

  if (confirmed) {
    // User confirmed, proceed with deletion
    window.location.href = "dlt_transaction?id=" + transactionId; // Replace with your deletion URL
  } else {
    // User cancelled
    return;
  }
}

//delete agent
function deleteAgent(buttonElement) {
  const agentID = buttonElement.getAttribute("data-Agent-id");
  const confirmed = confirm(
    "Are you sure you want to delete this Agent? This action cannot be undone."
  );

  if (confirmed) {
    // User confirmed, proceed with deletion
    window.location.href = "dlt_agent?id=" + agentID; // Replace with your deletion URL
  } else {
    // User cancelled
    return;
  }
}
// validate form

function validateForm() {
  var nameOfSender = document.getElementById("name_of_sender").value;
  var numberOfSender = document.getElementById("number_of_sender").value;
  var amount = document.getElementById("amount").value;
  var fee = document.getElementById("fee").value;
  var numberofReceiver = document.getElementById("number_of_reciever").value;

  if (
    nameOfSender === "" ||
    numberOfSender === "" ||
    amount === "" ||
    fee === "" ||
    numberofReceiver === ""
  ) {
    Toastify({
      text: "Please fill in all required fields.",
      duration: 6000,
      backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)",
    }).showToast();
    return false;
  }

  if (
    isNaN(parseFloat(amount)) ||
    isNaN(parseFloat(fee)) ||
    isNaN(parseFloat(numberOfSender)) ||
    isNaN(parseFloat(numberofReceiver))
  ) {
    Toastify({
      text: "Please enter valid numeric values in Amount, Fee, Sender's Number, and Receiver's Number fields.",
      duration: 7000,
      backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)",
    }).showToast();
    return false;
  }

  return true;
}

function validateEditForm() {
  var amount = document.getElementById("amount").value;
  var fee = document.getElementById("fee").value;
  var numberOfSender = document.getElementById("number_of_sender").value;
  var numberofReceiver = document.getElementById("number_of_reciever").value;

  if (
    isNaN(parseFloat(amount)) ||
    isNaN(parseFloat(fee)) ||
    isNaN(parseFloat(numberOfSender)) ||
    isNaN(parseFloat(numberofReceiver))
  ) {
    Toastify({
      text: "Please enter valid numeric values in Amount, Fee, Sender's Number, and Receiver's Number fields.",
      duration: 6000,
      backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)",
    }).showToast();
    return false;
  }

  return true;
}

function validateAgentForm() {
  var agentName = $("#agent_name").val();
  var agentContact = $("#agent_contact").val();
  var username = $("#username").val();
  var email = $("#email").val();
  var password = $("#password").val();

  if (
    agentName === "" ||
    agentContact === "" ||
    username === "" ||
    email === "" ||
    password === ""
  ) {
    Toastify({
      text: "Please fill in all required fields.",
      duration: 4000,
      backgroundColor: "linear-gradient(to right, #FF5733, #FFB533)",
    }).showToast();
    return false;
  }

  return true;
}
document.addEventListener("DOMContentLoaded", function () {
  // Get all the "Print" buttons with the class "print-button"
  const printButtons = document.querySelectorAll(".print-button");

  // Add click event listener to each "Print" button
  printButtons.forEach(function (button) {
    button.addEventListener("click", function () {
      const transactionId = button.dataset.transactionId;
      window.location.href = `Print?TRID=${transactionId}`;
    });
  });
});

