<?php
session_start();
require_once 'partials/admin_functions.php';

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["id"])) {
    $transactionId = $_GET["id"];
    
    // Perform the actual deletion logic here
    // Example:
    $sql = "DELETE FROM transactions WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $transactionId); // Assuming id is an integer
    $result = $stmt->execute();
    
    if ($result) {
        // Deletion successful
        $_SESSION["delete_notification"] = "Transaction deleted successfully.";
    } else {
        // Deletion failed, handle error
        $_SESSION["delete_notification"] = "Error deleting transaction. Please try again.";
    }
}

// Redirect back to the page displaying transactions
header("Location: Transactions"); // Replace with your transactions page URL
exit;
?>
