<?php require_once('Auth/authorize.php');?>
<?php require_once('partials/admin_functions.php');?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Print Transactions</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <style>
    @media print {
  .invoice-box {
    max-width: unset;
    box-shadow: none;
    border: 0px;
  }
}
  </style>
</head>
<body>
  <div class="container">
    <div class="row">
      <div class="col text-center mt-4">
      <img src="images/adson.png" alt="Logo" class="img-fluid" style="max-width: 250px; height: auto;">
      <?php
      if (isset($_POST['print_multiple'])) {
        $startDate = $_POST['startDate'];
        $endDate = $_POST['endDate'];
        $agent = $_POST['agent'];
        $operator = $_POST['operator'];
  $allTransactions = getAllTransactionsWithinDateRange($startDate, $endDate,$agent,$operator);
      }else {
        echo '
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
        Please Provide Date Range
         <button type="button" class="close" data-dismiss="alert" aria-label="Close">
             <span aria-hidden="true">&times;</span>
         </button>
     </div>';
      }

?>
      </div>
    </div>
    <div class="row">
    <div class="col">
        <h2 class="text-left mt-4 text-danger"><strong>Transaction Records</strong></h2>
    </div>
    <div class="col">
        <?php
        if (isset($_POST['print_multiple'])) {
            echo "<p class='text-right mt-4'>Date Range: <b>$startDate</b> to <b>$endDate</b></p>";
            echo "<p class='text-right mt-4'>Agent Name:<b> $agent</b> Operator <b>$operator</b></p>";
        }
        ?>
    </div>
</div>

    <div class="row">
      <div class="col">
      <table class="table table-hover">
                      <thead>
                        <tr>
                          <th>#</th>
                          <th>#TransID</th>
                          <th>Sender's Name</th>
                          <th>Served_by</th>
                          <th>Amount</th>
                          <th>Operator</th>
                          <th>Notes</th>
                          <th>Date</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php if (isset($_POST['print_multiple'])):?>
                        <?php foreach ($allTransactions as $key => $transaction):?>
                        <tr>
                          <td><?php echo $key+1;?></td>
                          <td><?php echo $transaction['transaction_id'];?></td>
                          <td><?php echo $transaction['sender_name'];?></td>
                          <td><?php echo $transaction['completed_by'];?></td>
                          <td>$<?php echo $transaction['amount'];?></td>
                          <td><?php echo $transaction['operator'];?></td>

                          <td><?php echo $transaction['notes'];?></td>
                          <td><?php echo date('F j, Y g:i A', strtotime($transaction['completed_at'])); ?></td>
                        </tr>
                      
                        <?php endforeach?>
                        <?php endif;?>
                      </tbody>
                    </table>
      </div>
    </div>
  </div>
</body>
</html>
