<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: Auth/login'); // Redirect to the login page
    exit;
}

// Check if the user's role is allowed to access the page
$allowedRoles = array("Director", "Operation Manager", "Consultant");
if (!in_array($_SESSION['user_role'], $allowedRoles)) {
    // Redirect to a page indicating access denied or somewhere else
    header('Location: ../Agent/dashboard');
    exit;
}

// If the user has the allowed role, continue with the rest of the page logic
// ...
?>